/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_PRESENCE_INTERFACE_H_
#define _SCE_PRESENCE_INTERFACE_H_

#include "np_toolkit_defines.h"

namespace sce { 
	namespace Toolkit {
		namespace NP {
		///	@brief
		///	The namespace containing presence functionality.
		///
		///	The namespace containing presence functionality.	
		namespace Presence {
		///	@brief
		///	Allows a user's presence to be managed.
		///
		///	Allows a user's presence to be managed.
		/// This includes information on a user's current stage, location, or any other in-game information that may be of interest.
		class Interface
		{
		public:

			///	@brief
			///	Set a user's presence.
			///
			///	Set a user's presence.
			///
			/// If the process is asynchronous the application is notified by a <c>presenceSet</c>
			/// Event.
			///
			///	@param presDetails					The status and data of the user.
			/// @param  async						A flag that indicates whether the function is non-blocking or blocking. 
			///										Defaults to true so the function is non-blocking by default.	
			///
			///	@retval	SCE_TOOLKIT_NP_SUCCESS						The operation was successful.
			///	@retval	SCE_TOOLKIT_NP_PRESENCE_STRING_TOO_LONG		The operation failed because the string containing user's status was too long (over 63 characters).
			///	@retval	SCE_TOOLKIT_NP_PRESENCE_DATA_TOO_BIG		The operation failed because the user data was too big (over 128 bytes).
			///
			///	@par Example:
			///	@code
			///	int ret = 0;
			///	PresenceService::PresenceDetails testPres;
			///	memset(&testPres, 0x00, sizeof(testPres));
			///	testPres.status = "This is the NP Toolkit presence test\n";
			///	int ret = Presence::Interface::setPresence(testPres, 1);
			///	if(ret < 0){
			///		// Error handling
			///	}
			/// @endcode
			static int setPresence(const PresenceDetails* presDetails, bool async= true);
		};

			}//end Presence
		}//end NP
	}//end Toolkit
}//end sce
#endif
